/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.UncheckedException;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.CompatibilityMatrix;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.PlatformInfo;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.RemoteDirException;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiix.OiixFileOps;

public class FileInfo {
    private static final Logger logger = Logger.getLogger(CompatibilityMatrix.class.getName());
    private OiipgFileSystem fileSystem = new OiipgFileSystem();
    private static FileInfo instance;

    protected FileInfo() {
    }

    public static FileInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (FileInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(FileInfo.class)) == null) {
            instance = new FileInfo();
        }
        return instance;
    }

    public boolean areLocsSame(String sNatUserHomeLoc, String sNatLoc) {
        return this.fileSystem.areLocsSame(sNatUserHomeLoc, sNatLoc);
    }

    public boolean isRemoteDirWriatble(String node, String dir) {
        try {
            ClusterCmd cc = new ClusterCmd();
            return cc.isDirWritable(node, dir);
        }
        catch (ClusterException ce) {
            ce.printStackTrace();
            logger.severe("occured while checking permissions for " + dir + "on host " + node);
            return false;
        }
    }

    public boolean doesRemoteDirExist(String node, String dir) {
        try {
            ClusterCmd cc = new ClusterCmd();
            return cc.dirExists(node, dir);
        }
        catch (RemoteDirException re) {
            logger.log(Level.WARNING, String.format("Failed while checking for %s directory existance on remote node %s using SRVM API.", dir, node), re);
            throw new UncheckedException((Throwable)re, (ErrorCode)CommonErrorCode.UNEXPECTED_REMOTE_DIR_CHECK_FAILURE, new Object[]{dir, node});
        }
    }

    public static String getLastExistingParent(String inputPath) {
        File f = new File(inputPath);
        if (f.exists() && f.isDirectory()) {
            return inputPath;
        }
        return FileInfo.getLastExistingParent(f.getParent().toString());
    }

    public String getLastExistingRemoteParent(String node, String location) {
        boolean fileExists = false;
        String dirToCheck = location;
        while (!fileExists) {
            fileExists = this.doesRemoteDirExist(node, dirToCheck);
            if (fileExists) continue;
            if (dirToCheck.lastIndexOf(File.separatorChar) == 0) {
                dirToCheck = File.separator;
                continue;
            }
            dirToCheck = dirToCheck.substring(0, dirToCheck.lastIndexOf(File.separatorChar));
        }
        return dirToCheck;
    }

    public int changeGroup(String loc, String group) {
        int retCode = OiixFileOps.changeGroup((String)loc, (String)group);
        return retCode;
    }

    public int changePermission(File file, String permissions, boolean recursive) throws InstallException {
        if (!file.exists()) {
            throw new InstallException((ErrorCode)CommonErrorCode.INSTALL_COMMON_FILE_DOESNOT_EXIST, file.getAbsolutePath());
        }
        int retCode = OiixFileOps.changePermissions((String)file.getAbsolutePath(), (String)permissions);
        if (retCode == 0 && recursive && file.isDirectory()) {
            File childFile;
            File[] files;
            File[] arr$ = files = file.listFiles();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (retCode = this.changePermission(childFile = arr$[i$], permissions, recursive)) == 0; ++i$) {
            }
        }
        return retCode;
    }

    public void updateValuesToFile(File sourceFile, File destinationFile, HashMap<String, String> map) {
        try {
            if (sourceFile.exists() && sourceFile.canRead()) {
                Set<String> keys;
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(sourceFile)));
                String line = "";
                if (map != null && (keys = map.keySet()) != null && keys.size() > 0) {
                    List<String> keyList = Arrays.asList(keys.toArray(new String[0]));
                    BufferedWriter writer = new BufferedWriter(new FileWriter(destinationFile));
                    while ((line = reader.readLine()) != null) {
                        String[] lineContent = line.split("=");
                        if (keyList.contains(lineContent[0])) {
                            StringBuffer buffer = new StringBuffer();
                            buffer.append(lineContent[0]);
                            buffer.append("=");
                            buffer.append(map.get(lineContent[0]));
                            writer.write(buffer.toString());
                        } else {
                            writer.write(line);
                        }
                        writer.newLine();
                    }
                    writer.flush();
                    writer.close();
                }
                reader.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.INFO, "IO Exception while replacing values in File", e);
        }
    }

    public String getWindowsShortPath(String longPath) {
        String loc = longPath;
        if (loc != null && loc.length() > 0) {
            Pattern pattern = Pattern.compile("\\s");
            Matcher matcher = pattern.matcher(loc);
            boolean found = matcher.find();
            if (found && PlatformInfo.getInstance().isWindows()) {
                loc = OiixFileOps.getWindowsShortFileName((String)longPath);
            }
            logger.log(Level.FINEST, "returning " + loc + " from getShortNameForLocation API");
        }
        return loc;
    }
}

